LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY full_adder_32 IS
   PORT (in1, in2: IN std_logic_vector (31 DOWNTO 0);
         cin: IN std_logic;
         sum: OUT std_logic_vector (31 DOWNTO 0);
         cout: OUT std_logic);
END full_adder_32;


ARCHITECTURE beh_full_adder_32 of full_adder_32 IS
COMPONENT carry_lookahead_adder IS
   PORT (ina, inb: IN std_logic_vector (3 DOWNTO 0);
         cin: IN std_logic;
         sum: OUT std_logic_vector (3 DOWNTO 0);
         cout: OUT std_logic);
END COMPONENT;
SIGNAL c: std_logic_vector (8 DOWNTO 0);

BEGIN
 c(0) <= cin;
 U1: carry_lookahead_adder PORT MAP(in1 (3 DOWNTO 0), in2 (3 DOWNTO 0), c(0), sum (3 DOWNTO 0), c(1));
 U2: carry_lookahead_adder PORT MAP(in1 (7 DOWNTO 4), in2 (7 DOWNTO 4), c(1), sum (7 DOWNTO 4), c(2));
 U3: carry_lookahead_adder PORT MAP(in1 (11 DOWNTO 8), in2 (11 DOWNTO 8), c(2), sum (11 DOWNTO 8), c(3));
 U4: carry_lookahead_adder PORT MAP(in1 (15 DOWNTO 12), in2 (15 DOWNTO 12), c(3), sum (15 DOWNTO 12), c(4));
 U5: carry_lookahead_adder PORT MAP(in1 (19 DOWNTO 16), in2 (19 DOWNTO 16), c(4), sum (19 DOWNTO 16), c(5));
 U6: carry_lookahead_adder PORT MAP(in1 (23 DOWNTO 20), in2 (23 DOWNTO 20), c(5), sum (23 DOWNTO 20), c(6));
 U7: carry_lookahead_adder PORT MAP(in1 (27 DOWNTO 24), in2 (27 DOWNTO 24), c(6), sum (27 DOWNTO 24), c(7));
 U8: carry_lookahead_adder PORT MAP(in1 (31 DOWNTO 28), in2 (31 DOWNTO 28), c(7), sum (31 DOWNTO 28), c(8));
 cout <= c(8);
END beh_full_adder_32;
 
